defmodule Web.GameLive do
  use Web, :live_view

  def render(assigns) do
    ~H"""
    <%= for {id, nom, actif} <- @coups do %>
      <.live_component
          module={Web.MoveComponent} id={id} nom={nom} invalide={!actif}
          partie_id={@id} processus={@processus} joueur_id={@joueur_id} />
    <% end %>
    """
  end

  def mount(%{"id" => id}, %{"joueur" => nom}, socket) do
    socket =
      if connected?(socket) do
        with {id, _} <- Integer.parse(id),
             processus when not is_nil(processus) <- Jeu.trouver_partie(id),
             {:ok, joueur_id} <- Jeu.ajouter_joueur(id, processus, nom)
        do
          assign(socket, id: id, processus: processus, joueur_id: joueur_id, coups: [])
        else
          _ -> assign(socket, coups: [])
        end
      else
        assign(socket, coups: [])
      end

    {:ok, socket}
  end

  def handle_info(:actualiser, socket) do
    coups = Partie.coups(socket.assigns.processus, socket.assigns.joueur_id)
    {:noreply, assign(socket, :coups, coups)}
  end
end
